# getDirectoryToWatchFailedLookupLocationInfileNonRecursive

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Dos root: c:/

## RootDirForResolution: c:/

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/users

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/users/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/user

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/user/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/usr

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/usr/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/home

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/home/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/workspaces

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/somefile.d.ts                                                                               |                                                                                                |           |                                                                                                |
| c:/folderAtRoot/somefile.d.ts                                                                  | c:/folderAtRoot                                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/somefile.d.ts                                                          | c:/folderAtRoot/folder1                                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | c:/folderAtRoot/folder1/folder2                                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | c:/folderAtRoot/folder1/folder2/folder3                                                        | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |                                                                                                |
| c:/users/somefile.d.ts                                                                         |                                                                                                |           |                                                                                                |
| c:/users/username/somefile.d.ts                                                                |                                                                                                |           |                                                                                                |
| c:/users/username/folderAtRoot/somefile.d.ts                                                   | c:/users/username/folderAtRoot                                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/somefile.d.ts                                           | c:/users/username/folderAtRoot/folder1                                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | c:/users/username/folderAtRoot/folder1/folder2                                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |                                                                                                |
| c:/user/somefile.d.ts                                                                          | c:/user                                                                                        | false     |                                                                                                |
| c:/user/username/somefile.d.ts                                                                 | c:/user/username                                                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/somefile.d.ts                                                    | c:/user/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/user/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/user/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/usr/somefile.d.ts                                                                           | c:/usr                                                                                         | false     |                                                                                                |
| c:/usr/username/somefile.d.ts                                                                  | c:/usr/username                                                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/somefile.d.ts                                                     | c:/usr/username/folderAtRoot                                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | c:/usr/username/folderAtRoot/folder1                                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | c:/usr/username/folderAtRoot/folder1/folder2                                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |                                                                                                |
| c:/home/somefile.d.ts                                                                          | c:/home                                                                                        | false     |                                                                                                |
| c:/home/username/somefile.d.ts                                                                 | c:/home/username                                                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/somefile.d.ts                                                    | c:/home/username/folderAtRoot                                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/somefile.d.ts                                            | c:/home/username/folderAtRoot/folder1                                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | c:/home/username/folderAtRoot/folder1/folder2                                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |                                                                                                |
| c:/workspaces/somefile.d.ts                                                                    | c:/workspaces                                                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/somefile.d.ts                                                       | c:/workspaces/folderAtRoot                                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/somefile.d.ts                                               | c:/workspaces/folderAtRoot/folder1                                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/somefile.d.ts                                       | c:/workspaces/folderAtRoot/folder1/folder2                                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                               | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                       | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts               | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | false     |                                                                                                |

