# getDirectoryToWatchFailedLookupLocationIndirNonRecursive

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Dos root: c:/

## RootDirForResolution: c:/

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/users

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/users/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/user

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/user/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | true      |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/usr

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/usr/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | true      |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/home

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/home/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | true      |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/workspaces

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | false     |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/somefile.d.ts                                                                           | c:/dir                                                                                         | false     |                                                                                                |
| c:/folderAtRoot/dir/somefile.d.ts                                                              | c:/folderAtRoot/dir                                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/somefile.d.ts                                                      | c:/folderAtRoot/folder1/dir                                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | c:/folderAtRoot/folder1/folder2/dir                                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | false     |                                                                                                |
| c:/users/dir/somefile.d.ts                                                                     |                                                                                                |           |                                                                                                |
| c:/users/username/dir/somefile.d.ts                                                            | c:/users/username/dir                                                                          | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/somefile.d.ts                                               | c:/users/username/folderAtRoot/dir                                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | c:/users/username/folderAtRoot/folder1/dir                                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | false     |                                                                                                |
| c:/user/dir/somefile.d.ts                                                                      | c:/user/dir                                                                                    | false     |                                                                                                |
| c:/user/username/dir/somefile.d.ts                                                             | c:/user/username/dir                                                                           | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/somefile.d.ts                                                | c:/user/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/user/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/usr/dir/somefile.d.ts                                                                       | c:/usr/dir                                                                                     | false     |                                                                                                |
| c:/usr/username/dir/somefile.d.ts                                                              | c:/usr/username/dir                                                                            | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | c:/usr/username/folderAtRoot/dir                                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | c:/usr/username/folderAtRoot/folder1/dir                                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | false     |                                                                                                |
| c:/home/dir/somefile.d.ts                                                                      | c:/home/dir                                                                                    | false     |                                                                                                |
| c:/home/username/dir/somefile.d.ts                                                             | c:/home/username/dir                                                                           | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/somefile.d.ts                                                | c:/home/username/folderAtRoot/dir                                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | c:/home/username/folderAtRoot/folder1/dir                                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | false     |                                                                                                |
| c:/workspaces/dir/somefile.d.ts                                                                | c:/workspaces/dir                                                                              | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/somefile.d.ts                                                   | c:/workspaces/folderAtRoot/dir                                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/somefile.d.ts                                           | c:/workspaces/folderAtRoot/folder1/dir                                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                   | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                   | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts           | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | true      |                                                                                                |

