const MAX_UNICODE_CODEPOINT = 0x10FFFF;
/** @type {(c: string) => boolean} */
const isStart = c => /\p{ID_Start}/u.test(c); // Other_ID_Start explicitly included for back compat - see http://www.unicode.org/reports/tr31/#Introduction
/** @type {(c: string) => boolean} */
const isPart = c => /\p{ID_Continue}/u.test(c) || isStart(c); // Likewise for Other_ID_Continue
const parts = [];
let partsActive = false;
let startsActive = false;
const starts = [];

for (let i = 0; i < MAX_UNICODE_CODEPOINT; i++) {
    if (isStart(String.fromCodePoint(i)) !== startsActive) {
        starts.push(i - +startsActive);
        startsActive = !startsActive;
    }
    if (isPart(String.fromCodePoint(i)) !== partsActive) {
        parts.push(i - +partsActive);
        partsActive = !partsActive;
    }
}

console.log(`/**
 * Generated by scripts/regenerate-unicode-identifier-parts.mjs on node ${process.version} with unicode ${process.versions.unicode}
 * based on http://www.unicode.org/reports/tr31/ and https://www.ecma-international.org/ecma-262/6.0/#sec-names-and-keywords
 * unicodeESNextIdentifierStart corresponds to the ID_Start and Other_ID_Start property, and
 * unicodeESNextIdentifierPart corresponds to ID_Continue, Other_ID_Continue, plus ID_Start and Other_ID_Start
 */`);
console.log(`// dprint-ignore`);
console.log(`const unicodeESNextIdentifierStart = [${starts.join(", ")}];`);
console.log(`// dprint-ignore`);
console.log(`const unicodeESNextIdentifierPart = [${parts.join(", ")}];`);
