# Contributing to PycURL

## Issues

Please take a moment to consider whether your issue is a bug report or a
support request.

A bug report should contain code to reproduce the bug, patch to fix the bug,
or at the very least a pointer to some code in PycURL that you suspect to be
the problem. If you don't have any of these, your issue is likely a support
request.

Please send support requests to our mailing list:

https://lists.haxx.se/listinfo/curl-and-python

People have also had success with getting help at Stack Overflow.

If you are not sure whether your issue is a support request or a bug report,
please post it to the mailing list.

## Pull Requests

Thanks for writing a patch!

PycURL supports many Python versions, libcurl versions and SSL backends.
When you submit a pull request, Travis CI will run PycURL test suite
against it on a bunch of different configurations. Please check back after
10-15 minutes to see if the tests passed. A message will be shown in
the pull request as to whether the build and test suite succeeded with your
patch applied.
