// run

// Copyright 2022 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package main

import "math"

func checkClearSlice() {
	s := []int{1, 2, 3}
	clear(s)
	for i := range s {
		if s[i] != 0 {
			panic("clear not zeroing slice elem")
		}
	}

	clear([]int{})
}

func checkClearMap() {
	m1 := make(map[int]int)
	m1[0] = 0
	m1[1] = 1
	clear(m1)
	if len(m1) != 0 {
		panic("m1 is not cleared")
	}

	// map contains NaN keys is also cleared.
	m2 := make(map[float64]int)
	m2[math.NaN()] = 1
	m2[math.NaN()] = 1
	clear(m2)
	if len(m2) != 0 {
		panic("m2 is not cleared")
	}

	clear(map[int]int{})
}

func main() {
	checkClearSlice()
	checkClearMap()
}
