# Contributing

Welcome to firejail, and thank you for your interest in contributing!

## Support

Make sure that you are using a [supported version](SECURITY.md) of firejail
before commenting on an issue/discussion/PR or opening a new one.

## Opening an issue

We welcome issues, whether to ask a question, provide information, request a
new profile or feature, or to report a suspected bug or problem.

If you want to request a program profile that we don't already have, please add
a comment in our dedicated issue:

- [Profile requests](https://github.com/netblue30/firejail/issues/1139)

When submitting a bug report, please provide the following information so that
we can handle the report more easily:

- firejail version.  If you're not sure, open a terminal and type `firejail
  --version`.
- Linux distribution (so that we can try to reproduce it, if necessary).
- If you know that the problem did not exist in an earlier version of firejail,
  please mention it.
- If you are reporting that a program does not work with firejail, please also
  run firejail with the `--noprofile` argument.  For example, if `firejail
  firefox` does not work, please also run `firejail --noprofile firefox` and
  let us know if it runs correctly or not.
- You may also try disabling various options provided in
  `/etc/firejail/<ProgramName.profile>` until you find out which one causes
  problems.  It will significantly help in finding a solution for your issue.

Please note: If you are running Debian, Ubuntu, Linux Mint, or another related
distribution and you installed firejail from your distro's repositories, please
ensure that **all** of the following packages were installed:

- firejail
- firejail-profiles

A common source of issues is that firejail-profiles was not installed when
installing firejail.

## Security vulnerabilities

See [SECURITY.md](SECURITY.md).

## Opening a pull request

Pull requests with enhancements, bugfixes or new profiles are very welcome.

If you want to write a new profile, the easiest way to do this is to use the
profile template:

- [etc/templates/profile.template](etc/templates/profile.template)

If you have already written a profile, please make sure it follows the rules
described in the template.

If you add a new command, here's the checklist:

- [ ] Update manpages: firejail(1) and firejail-profile(5)
- [ ] Update shell completions
- [ ] Update syntax files (run `make syntax` or just `make`)
- [ ] Update --help

## Editing the wiki

You are highly encouraged to add your own tips and tricks to the
[wiki](https://github.com/netblue30/firejail/wiki).
